sampler texture0 : register(s0);
				
float4x4 WorldViewProjectionTransform  : WORLDVIEWPROJ;
float2 fTextureSize;

struct VS_OUTPUT 
{
   float4 Position   : POSITION0;
   float2 TexCoord   : TEXCOORD0;
};
VS_OUTPUT vertexMain(
				float4 vPosition : POSITION,
				float2 texCoord0 : TEXCOORD0)
{
   VS_OUTPUT Output; 

   Output.Position = mul(vPosition, WorldViewProjectionTransform);
   Output.TexCoord = texCoord0;   

   return Output;
}

float4 pixelMain(VS_OUTPUT In) : COLOR0
{
   float2 coord = In.TexCoord; 
   coord += 1.f / fTextureSize / 2.f;
   return tex2D(texture0, coord);
}