sampler texture0 : register(s0);
sampler texture1 : register(s1);

float2 fTextureSize;
float4x4 WorldViewProjectionTransform  : WORLDVIEWPROJ;

float fTime = 1.f;
float fDuration = 1.f;

struct VS_OUTPUT 
{
   float4 Position   : POSITION0;
   float2 TexCoord   : TEXCOORD0;
};

VS_OUTPUT vertexMain(float4 vPosition: POSITION, float2 texCoord0: TEXCOORD0)
{
   VS_OUTPUT Output; 
   
   Output.Position = mul(vPosition, WorldViewProjectionTransform);
   Output.TexCoord = texCoord0;   

   return Output;
}

float4 pixelMain(VS_OUTPUT In) : COLOR0
{
	float fAlpha = saturate(fTime / fDuration) - saturate((fTime - (1.f - fDuration)) / fDuration);

   float2 coord = In.TexCoord + (1.f / fTextureSize / 2.f);
   float4 result = tex2D(texture0, coord);
   result.a = min(tex2D(texture1, coord).r, fAlpha);
   return result;
}