function example(img) 
    local brightness_diff = mean_l(img) - 140.0
    if brightness_diff < 0 then
        if brightness_diff <= -60.0 then
            gamma(img, 1.2)            
        elseif brightness_diff <= -40.0 then
            gamma(img, 1.1)            
        elseif brightness_diff <= -20.0 then
            gamma(img, 1.05)
        end
    else
        if brightness_diff >= 60.0 then
            gamma(img, 0.85)            
        elseif brightness_diff >= 40.0 then
            gamma(img, 0.90)            
        elseif brightness_diff >= 20.0 then
            gamma(img, 0.95)
        end
    end
    
    white_balance(img, "simplest", false, 0.004, 0.004)   
    
    reset_analyzer(img)

    if (quantile25l(img) >= 64.0) then
        shadows_curve(img, 1.9)
        midtones_curve(img, 1.8)        
    else
        shadows_curve(img, 1.65)
        midtones_curve(img, 1.6)        
    end
    darks_curve(img, 1.3) 
    highlights_curve(img, 1.1)
    darks_curve(img, -1.2)

    reset_analyzer(img)   
    -- if quantile75l(img) <= 224 then
    --     temperature(img, 6675)
    -- end
    if contrast_rms(img) < 22000 then
        specialized_s_curve(img, 0.80, 0.5)
    else
        specialized_s_curve(img, 0.85, 0.5)
    end

    local satt_diff = 0.618 - mean_s(img) 
    if satt_diff > 0 and satt_diff < 1.0 then
        saturation(img, satt_diff * 0.618)
    elseif satt_diff >= 1.0 then
        saturation(img, 0.99)
    else
        saturation(img, 0.30)
    end 
end
