/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.discmenu;

import de.ashampoo.ashxml.XmlNode;
import de.ashampoo.discmenu.DiscMenuException;
import de.ashampoo.discmenu.DiscMenuInterface;
import de.ashampoo.discmenu.DisplaySettings;
import de.ashampoo.discmenu.Page;
import java.util.Vector;

public class Menu
implements DiscMenuInterface {
    DisplaySettings displaySettings = new DisplaySettings();
    Vector pages = new Vector();

    public void loadFromXml(XmlNode node) throws DiscMenuException {
        XmlNode displaySettingsNode;
        XmlNode pagesNode = node.findChild("pages");
        if (pagesNode == null) {
            throw new DiscMenuException("could not find any pages in menufile");
        }
        Vector pageNodes = pagesNode.findAllChildren("page");
        if (pageNodes.size() > 0) {
            boolean mainpageFound = false;
            for (int i = 0; i < pageNodes.size(); ++i) {
                XmlNode child = (XmlNode)pageNodes.get(i);
                Page page = new Page();
                page.loadFromXml(child);
                this.pages.add(page);
                if (!page.getId().equals("mainpage")) continue;
                mainpageFound = true;
            }
            if (!mainpageFound) {
                throw new DiscMenuException("no mainpage could be found ");
            }
        }
        if ((displaySettingsNode = node.findChild("display-settings")) == null) {
            throw new DiscMenuException("could not find a display-settings node in menufile");
        }
        this.displaySettings.loadFromXml(displaySettingsNode);
    }

    public int getPageIndex(String pageId) {
        for (int i = 0; i < this.pages.size(); ++i) {
            Page page = (Page)this.pages.get(i);
            if (!page.getId().equals(pageId)) continue;
            return i;
        }
        return -1;
    }

    public Page getPage(int id) {
        if (id < 0 || id >= this.pages.size()) {
            return null;
        }
        return (Page)this.pages.get(id);
    }

    public DisplaySettings getDisplaySettings() {
        return this.displaySettings;
    }
}

