/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.discmenu;

import de.ashampoo.ashxml.XmlNode;
import de.ashampoo.discmenu.Action;
import de.ashampoo.discmenu.DiscMenuException;
import de.ashampoo.discmenu.DiscMenuInterface;
import de.ashampoo.discmenu.State;
import de.ashampoo.discmenu.StateName;
import java.util.Vector;

public class Button
implements DiscMenuInterface {
    private double x = 0.0;
    private double y = 0.0;
    private double width = 0.0;
    private double height = 0.0;
    private String id = "";
    private Vector states = new Vector();
    private Vector onSelect = new Vector();
    private Vector onUp = new Vector();
    private Vector onDown = new Vector();
    private Vector onLeft = new Vector();
    private Vector onRight = new Vector();

    public void loadAction(XmlNode node, Vector target, String nodename) throws DiscMenuException {
        XmlNode actionNode = node.findChild(nodename);
        if (actionNode != null) {
            Vector actions = actionNode.findAllChildren("action");
            for (int i = 0; i < actions.size(); ++i) {
                XmlNode element = (XmlNode)actions.get(i);
                Action action = new Action();
                action.loadFromXml(element);
                target.add(action);
            }
        }
    }

    public void loadFromXml(XmlNode node) throws DiscMenuException {
        this.x = node.getDoubleAttribute("x");
        this.y = node.getDoubleAttribute("y");
        this.width = node.getDoubleAttribute("width");
        this.height = node.getDoubleAttribute("height");
        if (this.width == 0.0 || this.height == 0.0) {
            throw new DiscMenuException("width and height can't be zero for button");
        }
        this.id = node.getAttribute("id");
        if (this.id.equals("")) {
            throw new DiscMenuException("width and height can't be zero for button");
        }
        XmlNode statesNode = node.findChild("states");
        if (statesNode == null) {
            throw new DiscMenuException("could not find any button states");
        }
        for (int i = 0; i < statesNode.getChildCount(); ++i) {
            XmlNode stateNode = statesNode.getChild(i);
            State state = new State();
            state.loadFromXml(stateNode);
            this.states.add(state);
        }
        this.loadAction(node, this.onSelect, "onSelect");
        this.loadAction(node, this.onLeft, "onLeft");
        this.loadAction(node, this.onRight, "onRight");
        this.loadAction(node, this.onUp, "onUp");
        this.loadAction(node, this.onDown, "onDown");
    }

    public double getHeight() {
        return this.height;
    }

    public String getId() {
        return this.id;
    }

    public double getWidth() {
        return this.width;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String getStateSrc(String name) {
        StateName paramState = StateName.getStateName(name);
        for (int i = 0; i < this.states.size(); ++i) {
            State state = (State)this.states.get(i);
            if (state.getName() != paramState) continue;
            return state.getSrc();
        }
        return "";
    }

    public int getOnSelectCount() {
        return this.onSelect.size();
    }

    public Action getOnSelect(int i) {
        return (Action)this.onSelect.get(i);
    }

    public int getOnUpCount() {
        return this.onUp.size();
    }

    public Action getOnUp(int i) {
        return (Action)this.onUp.get(i);
    }

    public int getOnDownCount() {
        return this.onDown.size();
    }

    public Action getOnDown(int i) {
        return (Action)this.onDown.get(i);
    }

    public int getOnLeftCount() {
        return this.onLeft.size();
    }

    public Action getOnLeft(int i) {
        return (Action)this.onLeft.get(i);
    }

    public int getOnRightCount() {
        return this.onRight.size();
    }

    public Action getOnRight(int i) {
        return (Action)this.onRight.get(i);
    }
}

