/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj.util;

import de.ashampoo.bdj.ButtonActionListener;
import de.ashampoo.bdj.MenuHandler;
import de.ashampoo.bdj.debug.Log;
import de.ashampoo.bdj.gui.Container;
import de.ashampoo.bdj.gui.Point;
import de.ashampoo.bdj.gui.RootContainer;
import de.ashampoo.bdj.gui.SelectionListener;
import de.ashampoo.bdj.util.GuiBuilderException;
import de.ashampoo.bdj.util.ResourceLoader;
import de.ashampoo.discmenu.Action;
import de.ashampoo.discmenu.ActionType;
import de.ashampoo.discmenu.Button;
import de.ashampoo.discmenu.Page;
import java.awt.Component;
import java.awt.Image;

public class GuiBuilder {
    private static GuiBuilder instance = null;

    public static synchronized GuiBuilder getInstance() {
        if (instance == null) {
            instance = new GuiBuilder();
        }
        return instance;
    }

    private GuiBuilder() {
    }

    private void addButton(Component gui, Container parent, Button button, final ButtonActionListener listener) throws GuiBuilderException {
        Action action;
        int x = (int)(button.getX() * (double)MenuHandler.getInstance().getWidth());
        int y = (int)(button.getY() * (double)MenuHandler.getInstance().getHeight());
        Point position = new Point(x, y);
        String id = button.getId();
        String imgHighlight = button.getStateSrc("hover");
        Image highlightImg = ResourceLoader.getInstance().loadImage(gui, imgHighlight);
        if (highlightImg == null) {
            throw new GuiBuilderException("hover image '" + button.getStateSrc("hover") + "' could not be loaded from resources");
        }
        de.ashampoo.bdj.gui.Button result = new de.ashampoo.bdj.gui.Button(parent, position, id, highlightImg);
        Log.getInstance().log(this.getClass(), "adding button '" + button.getId() + "'  selectionlistenercount=" + button.getOnSelectCount());
        if (button.getOnUpCount() > 0 && (action = button.getOnUp(0)).getType().equals(ActionType.select)) {
            result.setUpComponent(action.getTarget());
        }
        if (button.getOnDownCount() > 0 && (action = button.getOnDown(0)).getType().equals(ActionType.select)) {
            result.setDownComponent(action.getTarget());
        }
        if (button.getOnLeftCount() > 0 && (action = button.getOnLeft(0)).getType().equals(ActionType.select)) {
            result.setLeftComponent(action.getTarget());
        }
        if (button.getOnRightCount() > 0 && (action = button.getOnRight(0)).getType().equals(ActionType.select)) {
            result.setRightComponent(action.getTarget());
        }
        for (int i = 0; i < button.getOnSelectCount(); ++i) {
            final Action action2 = button.getOnSelect(i);
            if (action2.getType().equals(ActionType.play)) {
                result.addSelectionListener(new SelectionListener(){

                    public void onButtonSelected(de.ashampoo.bdj.gui.Button button) {
                        Log.getInstance().log(this.getClass(), "on select play button: playlist=" + action2.getInfileId() + " chapter=" + action2.getChapter());
                        listener.onPlayInfile(action2.getInfileId(), action2.getChapter());
                    }
                });
                continue;
            }
            if (action2.getType().equals(ActionType.playall)) {
                result.addSelectionListener(new SelectionListener(){

                    public void onButtonSelected(de.ashampoo.bdj.gui.Button button) {
                        listener.onPlayall();
                    }
                });
                continue;
            }
            if (action2.getType().equals(ActionType.page)) {
                result.addSelectionListener(new SelectionListener(){

                    public void onButtonSelected(de.ashampoo.bdj.gui.Button button) {
                        listener.onSelectButton(action2.getTarget());
                    }
                });
                continue;
            }
            if (!action2.getType().equals(ActionType.back)) continue;
            result.addSelectionListener(new SelectionListener(){

                public void onButtonSelected(de.ashampoo.bdj.gui.Button button) {
                    listener.onBack();
                }
            });
        }
        parent.add(result);
    }

    public RootContainer buildGui(Component gui, Page page, ButtonActionListener listener) {
        RootContainer container = new RootContainer();
        try {
            for (int i = 0; i < page.getButtonCount(); ++i) {
                Button button = page.getButton(i);
                this.addButton(gui, container, button, listener);
            }
        }
        catch (Exception e) {
            Log.getInstance().logException(this.getClass(), e);
        }
        return container;
    }
}

