/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj.util;

import de.ashampoo.bdj.MasterXlet;
import de.ashampoo.bdj.debug.Log;
import de.ashampoo.bdj.util.ResourceLoader;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.StartEvent;
import javax.media.StopByRequestEvent;
import javax.media.StopEvent;
import javax.media.Time;
import javax.tv.locator.Locator;
import javax.tv.service.SIManager;
import javax.tv.service.Service;
import javax.tv.service.selection.ServiceContext;
import javax.tv.service.selection.ServiceContextFactory;
import javax.tv.xlet.XletContext;
import org.bluray.net.BDLocator;
import org.havi.ui.HSound;

public class AshPlayer {
    private static AshPlayer instance = null;
    private static MasterXlet mainXlet = null;
    private static XletContext xletContext = null;
    private Player currentPlayer = null;
    private boolean playingMenufile = false;
    private boolean setNewFile = false;

    public static AshPlayer getInstance() {
        if (instance == null) {
            instance = new AshPlayer();
        }
        return instance;
    }

    public static void setXletContext(XletContext xletContext) {
        AshPlayer.xletContext = xletContext;
    }

    public boolean isPlaying() {
        return this.currentPlayer != null && !this.playingMenufile;
    }

    public static void setMainXlet(MasterXlet mainXlet) {
        AshPlayer.mainXlet = mainXlet;
    }

    private AshPlayer() {
    }

    public void playAudioFile(String filename) {
        try {
            HSound player = new HSound();
            String realFilename = ResourceLoader.getInstance().getSoundFile(filename);
            Log.getInstance().log(this.getClass(), "playing Audio file in loop: " + realFilename);
            player.load(realFilename);
            player.loop();
        }
        catch (Exception e) {
            Log.getInstance().logException(this.getClass(), e);
        }
    }

    private String getMediaLocatorUri(String playlist) {
        return "bd://PLAYLIST:" + playlist;
    }

    private String getMediaLocatorTitleUri(String titleId) {
        return "bd://" + titleId;
    }

    private boolean playTitleInt(String title) {
        try {
            String mediaLocatorUri = this.getMediaLocatorTitleUri(title);
            Log.getInstance().log(this.getClass(), "playing titileid: " + mediaLocatorUri);
            BDLocator locator = new BDLocator(mediaLocatorUri);
            SIManager manager = SIManager.createInstance();
            Service service = manager.getService((Locator)locator);
            ServiceContext context = ServiceContextFactory.getInstance().getServiceContext(xletContext);
            context.select(service);
            return true;
        }
        catch (Exception e) {
            Log.getInstance().logException(this.getClass(), e);
            return false;
        }
    }

    public boolean playTitleAll() {
        return this.playTitleInt("0002");
    }

    public boolean playTitle() {
        return this.playTitleInt("0003");
    }

    public boolean playPlaylist(final String playlist, final double startTime, final boolean playingMenufile) {
        try {
            this.setNewFile = true;
            this.stopPlayback();
            this.setNewFile = false;
            String mediaLocatorUri = this.getMediaLocatorUri(playlist);
            this.currentPlayer = Manager.createPlayer((MediaLocator)new MediaLocator(mediaLocatorUri));
            Log.getInstance().log(this.getClass(), "Starting play of playlist: " + playlist);
            this.playingMenufile = playingMenufile;
            this.currentPlayer.addControllerListener(new ControllerListener(){
                boolean hasSkipped = false;

                public void controllerUpdate(ControllerEvent ce) {
                    Log.getInstance().log(this.getClass(), "event received type=" + ce.getClass().getName());
                    if (ce instanceof StartEvent) {
                        if (startTime > 0.0 && !this.hasSkipped) {
                            this.hasSkipped = true;
                            try {
                                Log.getInstance().log(this.getClass(), "setting starttimestamp of player to " + startTime);
                                AshPlayer.this.currentPlayer.setMediaTime(new Time(startTime));
                            }
                            catch (Exception ex) {
                                Log.getInstance().logException(this.getClass(), ex);
                            }
                        }
                        if (playingMenufile) {
                            mainXlet.doFullRepaint();
                        }
                    } else if (AshPlayer.this.setNewFile && ce instanceof StopEvent) {
                        AshPlayer.this.currentPlayer.close();
                        AshPlayer.this.currentPlayer = null;
                    } else if (ce instanceof EndOfMediaEvent) {
                        Log.getInstance().log(this.getClass(), "endofmediaevent play of playlist: " + playlist);
                        if (playingMenufile) {
                            AshPlayer.this.currentPlayer.start();
                        } else if (mainXlet != null) {
                            mainXlet.onResume(true);
                        }
                    } else if (ce instanceof StopByRequestEvent) {
                        AshPlayer.this.currentPlayer.close();
                        AshPlayer.this.currentPlayer = null;
                    }
                }
            });
            this.currentPlayer.start();
        }
        catch (Exception ex) {
            Log.getInstance().logException(this.getClass(), ex);
            return false;
        }
        return true;
    }

    public void stopPlayback() {
        if (this.currentPlayer == null) {
            return;
        }
        Log.getInstance().log(this.getClass(), "force stop of playback");
        this.currentPlayer.stop();
        while (this.currentPlayer != null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

