/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj.gui;

import de.ashampoo.bdj.gui.Animator;
import de.ashampoo.bdj.gui.Component;
import de.ashampoo.bdj.gui.Point;
import de.ashampoo.bdj.gui.Rectangle;
import java.awt.Graphics2D;
import java.awt.Image;

public class ImageAnimation
implements Component {
    private Component parent = null;
    private Image[] images = null;
    private int imageIndex = 0;
    private long delay = 0L;
    private long lastUpdateTime = 0L;
    private Rectangle rect = null;

    public ImageAnimation(Component parent, Point position, Image[] images, long delay) {
        this.parent = parent;
        this.images = images;
        this.delay = delay;
        this.rect = new Rectangle(position.x, position.y, images[0].getWidth(null), images[0].getHeight(null));
        this.lastUpdateTime = System.currentTimeMillis();
        Animator.getInstance().registerAnimation(this);
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public Component getParent() {
        return this.parent;
    }

    public synchronized void nextImage() {
        if (System.currentTimeMillis() - this.lastUpdateTime >= this.delay) {
            ++this.imageIndex;
            this.imageIndex %= this.images.length;
            this.lastUpdateTime = System.currentTimeMillis();
            this.invalidate();
        }
    }

    public synchronized void draw(Graphics2D g, Point pt) {
        Point newPt = new Point(this.rect.x + pt.x, this.rect.y + pt.y);
        g.drawImage(this.images[this.imageIndex], newPt.x, newPt.y, null);
    }

    public void invalidate() {
        this.parent.invalidateRect(this.rect);
    }

    public void invalidateRect(Rectangle rect) {
        this.invalidate();
    }
}

