/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj.gui;

import de.ashampoo.bdj.MenuHandler;
import de.ashampoo.bdj.debug.Log;
import de.ashampoo.bdj.debug.LogOverlay;
import de.ashampoo.bdj.gui.DirtyRectListener;
import de.ashampoo.bdj.gui.Rectangle;
import de.ashampoo.bdj.gui.RootContainer;
import de.ashampoo.bdj.util.AshPlayer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;
import org.dvb.ui.DVBColor;
import org.havi.ui.HScene;
import org.havi.ui.HSceneFactory;

public class GuiPainter
extends Container
implements DirtyRectListener {
    boolean debugEnabled = false;
    private HScene scene = null;
    private RootContainer gui = null;
    private static Font font = null;
    private static boolean showDebugAlways = false;
    private LogOverlay overlay = new LogOverlay();
    private Vector dirtyRects = new Vector();

    public GuiPainter() {
        font = new Font(null, 0, 48);
        this.scene = HSceneFactory.getInstance().getDefaultHScene();
        this.setSize(MenuHandler.getInstance().getWidth(), MenuHandler.getInstance().getHeight());
        this.scene.add((Component)this);
        this.scene.validate();
    }

    public synchronized void paint(Graphics graphics) {
        try {
            Graphics2D g = (Graphics2D)graphics;
            g.setFont(font);
            if (showDebugAlways) {
                g.setComposite(AlphaComposite.Src);
                g.setColor((Color)new DVBColor(0, 0, 0, 0));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setComposite(AlphaComposite.SrcOver);
                g.setColor(new Color(245, 245, 245));
                this.overlay.paintLastLinesOverlay(g);
            }
            for (int i = 0; i < this.dirtyRects.size(); ++i) {
                Rectangle rect = (Rectangle)this.dirtyRects.get(i);
                g.setClip(rect.x, rect.y, rect.width, rect.height);
                if (!showDebugAlways) {
                    g.setComposite(AlphaComposite.Src);
                    g.setColor((Color)new DVBColor(0, 0, 0, 0));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setComposite(AlphaComposite.SrcOver);
                }
                if (AshPlayer.getInstance().isPlaying()) continue;
                if (this.debugEnabled) {
                    g.setColor(Color.black);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(new Color(245, 245, 245));
                    this.overlay.paintOverlay(g);
                    continue;
                }
                if (this.gui == null) continue;
                this.gui.draw(g);
            }
            this.dirtyRects.clear();
        }
        catch (Exception e) {
            Log.getInstance().logException(this.getClass(), e);
        }
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        this.scene.setVisible(b);
    }

    public synchronized void destroy() {
        this.scene.remove((Component)this);
        this.scene = null;
    }

    public synchronized void setGui(RootContainer gui) {
        this.gui = gui;
    }

    public LogOverlay getOverlay() {
        return this.overlay;
    }

    public void doFullRepaint() {
        this.dirtyRects.clear();
        this.addDirtyRect(new Rectangle(0, 0, MenuHandler.getInstance().getWidth(), MenuHandler.getInstance().getHeight()));
        this.repaint();
    }

    public void addDirtyRect(Rectangle rect) {
        this.dirtyRects.add(rect);
        this.repaint();
    }

    public void invalidateAll() {
        this.doFullRepaint();
    }
}

