/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj.gui;

import de.ashampoo.bdj.gui.Component;
import de.ashampoo.bdj.gui.HighlightComponent;
import de.ashampoo.bdj.gui.Point;
import de.ashampoo.bdj.gui.Rectangle;
import de.ashampoo.bdj.gui.SelectionListener;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.Vector;

public class Button
implements HighlightComponent {
    private Component parent = null;
    private Rectangle rect = null;
    private Image highlightImg = null;
    private String id = null;
    private Vector selectionListener = new Vector();
    private String upComponent = "";
    private String downComponent = "";
    private String leftComponent = "";
    private String rightComponent = "";

    public Button(Component parent, Point position, String id, Image highlightImg) {
        this.parent = parent;
        this.highlightImg = highlightImg;
        this.id = id;
        this.rect = new Rectangle(position.x, position.y, highlightImg.getWidth(null), highlightImg.getHeight(null));
    }

    public String getId() {
        return this.id;
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public void invalidate() {
        this.parent.invalidateRect(this.rect);
    }

    public void invalidateRect(Rectangle rect) {
        this.invalidate();
    }

    public Component getParent() {
        return this.parent;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListener.add(listener);
    }

    public void fireSelectionEvent() {
        for (int i = 0; i < this.selectionListener.size(); ++i) {
            ((SelectionListener)this.selectionListener.get(i)).onButtonSelected(this);
        }
    }

    public void draw(Graphics2D g, Point pt) {
    }

    public void drawHighlight(Graphics2D g, Point pt) {
        Point newPt = new Point(pt.x + this.rect.x, pt.y + this.rect.y);
        g.drawImage(this.highlightImg, newPt.x, newPt.y, null);
    }

    public String getUpComponent() {
        return this.upComponent;
    }

    public String getDownComponent() {
        return this.downComponent;
    }

    public String getLeftComponent() {
        return this.leftComponent;
    }

    public String getRightComponent() {
        return this.rightComponent;
    }

    public void setDownComponent(String downComponent) {
        this.downComponent = downComponent;
    }

    public void setLeftComponent(String leftComponent) {
        this.leftComponent = leftComponent;
    }

    public void setRightComponent(String rightComponent) {
        this.rightComponent = rightComponent;
    }

    public void setUpComponent(String upComponent) {
        this.upComponent = upComponent;
    }
}

