/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj.debug;

import java.util.ArrayList;

public class Log {
    private static Log instance = null;
    private ArrayList entries = new ArrayList();

    public static synchronized Log getInstance() {
        if (instance == null) {
            instance = new Log();
        }
        return instance;
    }

    private Log() {
    }

    public synchronized void log(Class clazz, String message) {
        this.entries.add("[" + clazz.getName() + "] " + message);
    }

    public synchronized int getItemCount() {
        return this.entries.size();
    }

    public synchronized String getItem(int i) {
        return (String)this.entries.get(i);
    }

    public synchronized void logException(Class clazz, Exception e) {
        this.entries.add("Exception in [" + clazz.getName() + "]");
        this.entries.add("   " + e.toString());
    }

    public synchronized void logSystemProperties() {
        String[] propertiesToFetch = new String[]{"bluray.profile.1", "bluray.profile.2", "bluray.p1.version.major", "bluray.p1.version.minor", "bluray.p1.version.micro", "bluray.p2.version.major", "bluray.p2.version.minor", "bluray.p2.version.micro", "bluray.vfs.root", "bluray.bindingunit.root", "bluray.localstorage.level", "bluray.memory.images", "bluray.memory.audio", "bluray.memory.audio_plus_img", "bluray.memory.java_heap", "bluray.memory.font_cache"};
        try {
            for (int i = 0; i < propertiesToFetch.length; ++i) {
                try {
                    String value = System.getProperty(propertiesToFetch[i]);
                    if (value == null) {
                        value = "null";
                    }
                    this.log(this.getClass(), "[" + propertiesToFetch[i] + "] " + value);
                    continue;
                }
                catch (Exception e) {
                    this.logException(this.getClass(), e);
                }
            }
        }
        catch (Exception e) {
            this.logException(this.getClass(), e);
        }
    }
}

