/*
 * Decompiled with CFR 0.152.
 */
package de.ashampoo.bdj;

import de.ashampoo.bdj.ButtonActionListener;
import de.ashampoo.bdj.MenuHandler;
import de.ashampoo.bdj.debug.Log;
import de.ashampoo.bdj.gui.GuiPainter;
import de.ashampoo.bdj.gui.KeyManager;
import de.ashampoo.bdj.gui.RootContainer;
import de.ashampoo.bdj.util.AshPlayer;
import de.ashampoo.bdj.util.GuiBuilder;
import de.ashampoo.discmenu.Menu;
import de.ashampoo.discmenu.Page;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import javax.tv.xlet.Xlet;
import javax.tv.xlet.XletContext;
import org.bluray.system.RegisterAccess;

public class MasterXlet
implements Xlet,
ButtonActionListener {
    private KeyManager keyManager = null;
    private GuiPainter gui = null;
    private Stack pageStack = new Stack();

    public void initXlet(XletContext context) {
        AshPlayer.setMainXlet(this);
        AshPlayer.setXletContext(context);
        this.gui = new GuiPainter();
        RootContainer container = new RootContainer();
        this.gui.setGui(container);
        container.setDirtyRectListener(this.gui);
        this.keyManager = new KeyManager(this.gui, container, this);
        int lastPageIndex = RegisterAccess.getInstance().getGPR(1603);
        Page page = MenuHandler.getInstance().getMenu().getPage(lastPageIndex);
        if (page != null) {
            this.setActivePage(page.getId());
        } else {
            this.setActivePage("mainpage");
        }
    }

    public void startXlet() {
        if (this.gui != null) {
            this.gui.setVisible(true);
            this.gui.doFullRepaint();
        }
    }

    public void pauseXlet() {
        if (this.gui != null) {
            this.gui.doFullRepaint();
            this.gui.setVisible(false);
        }
    }

    public void destroyXlet(boolean unconditional) {
        if (this.keyManager != null) {
            this.keyManager.destroy();
        }
        if (this.gui != null) {
            this.gui.destroy();
        }
        this.keyManager = null;
        this.gui = null;
    }

    public void doFullRepaint() {
        if (this.gui != null) {
            this.gui.doFullRepaint();
        }
    }

    public void setActivePage(String pageId) {
        block6: {
            Log.getInstance().log(this.getClass(), "selecting page: '" + pageId + "'");
            try {
                Menu menu = MenuHandler.getInstance().getMenu();
                if (menu == null) break block6;
                int pageIndex = menu.getPageIndex(pageId);
                Page page = menu.getPage(pageIndex);
                if (page == null) {
                    Log.getInstance().log(this.getClass(), "could not find mainpage in menufile");
                }
                if (page != null) {
                    this.pageStack.push(pageId);
                    this.pauseXlet();
                    AshPlayer.getInstance().playPlaylist(page.getBackground().getInfileId(), 0.0, true);
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    RootContainer container = GuiBuilder.getInstance().buildGui(this.gui, page, this);
                    this.gui.setGui(container);
                    container.setDirtyRectListener(this.gui);
                    this.keyManager.setContainer(container);
                    RegisterAccess.getInstance().setGPR(1603, pageIndex);
                }
                this.startXlet();
            }
            catch (Exception e) {
                this.startXlet();
                Log.getInstance().logException(this.getClass(), e);
            }
        }
    }

    public void onPlayInfile(int playlist, int chapter) {
        Log.getInstance().log(this.getClass(), "onPlayInfile: playlist=" + playlist + " chapter=" + chapter);
        RegisterAccess.getInstance().setGPR(1983, playlist);
        RegisterAccess.getInstance().setGPR(1602, chapter);
        if (!AshPlayer.getInstance().playTitle()) {
            Log.getInstance().log(this.getClass(), "onplayinfile could not play playlist with number " + playlist);
        }
    }

    public void onSelectButton(String targetId) {
        try {
            this.setActivePage(targetId);
        }
        catch (Exception e) {
            Log.getInstance().logException(this.getClass(), e);
        }
    }

    public void onResume(boolean useDelay) {
        try {
            if (useDelay) {
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    public void run() {
                        MasterXlet.this.onResumeInt();
                    }
                }, 200L);
            } else {
                this.onResumeInt();
            }
        }
        catch (Exception e) {
            Log.getInstance().logException(this.getClass(), e);
        }
    }

    public void onBack() {
        try {
            if (this.pageStack.size() > 1) {
                this.pageStack.pop();
                String sOldPageId = (String)this.pageStack.pop();
                Log.getInstance().log(this.getClass(), "old page id: " + sOldPageId);
                if (sOldPageId != null) {
                    this.setActivePage(sOldPageId);
                }
            }
        }
        catch (Exception e) {
            Log.getInstance().logException(this.getClass(), e);
        }
    }

    public void onPlayall() {
        AshPlayer.getInstance().playTitleAll();
    }

    private void onResumeInt() {
        if (this.pageStack.size() > 0) {
            String sOldPageId = (String)this.pageStack.pop();
            Log.getInstance().log(this.getClass(), "resuming page id: " + sOldPageId);
            if (sOldPageId != null) {
                this.setActivePage(sOldPageId);
            }
        }
    }
}

